#ifdef GL_ES
precision mediump float;

varying vec2 pos;
vec4 fragColor;
#else
in vec2 pos;
out vec4 fragColor;
#endif
uniform float percent;
uniform vec4 color;
uniform vec4 inColor;

#define M_PI	(3.1415926535)

void main()
{
	float position = mod(atan(-pos.x,pos.y), 2.0 * M_PI) / (2.0 * M_PI);
	float select = smoothstep(percent, percent + 0.002, 1.0 - position);
	fragColor = mix(color, inColor, select);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
